
#include    "button.h"

u8 ButtonDebounceTime;
u8 ButtonRepeatTime;
u8 ButtonCurrentStatus;
u8 ButtonPreviousStatus;

byte_t x;

/*---------------------------------------------------------------------------*/
/* PA[6:4] = key															 */
/* PA7, PB4, PB3 = LED														 */
/*---------------------------------------------------------------------------*/
void BTN_InterfaceConfigure(void)
{
	BTN_PORTC = BTN_PORTC | BUTTON_KEY;
	BTN_PORTPU = BTN_PORTPU | BUTTON_KEY;
	BTN_PORTWU = BTN_PORTWU | BUTTON_KEY;
	
 	ButtonCurrentStatus = 0;
	ButtonPreviousStatus = 0;
	ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
	x.value = 0x00;
}
/*---------------------------------------------------------------------------*/
/*																			 */
/*---------------------------------------------------------------------------*/
u8 BTN_ScanStatus(void)
{
   

	x.value &= ~0x87;
	if(!BUTTON1_IN)  x.bits.b0 = 1;
	if(!BUTTON2_IN)  x.bits.b1 = 1;
	if(!BUTTON3_IN)  x.bits.b2 = 1;
     
	if((x.value & 0x07) ^ ButtonCurrentStatus)
	{
		ButtonCurrentStatus = x.value & 0x07;
		ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
		x.value |= 0x40;
	}
   else
   {
		if(--ButtonDebounceTime == 0)  
		{
			ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
			x.value &= ~0x40;
			if(ButtonCurrentStatus ^ ButtonPreviousStatus)
			{
				ButtonPreviousStatus = ButtonCurrentStatus;
				ButtonRepeatTime = BUTTON_REPEAT1_DURATION;
				x.value |= 0x80;
			}
			else
			{
				if((ButtonPreviousStatus != 0) && (--ButtonRepeatTime == 0))
				{
					ButtonRepeatTime = BUTTON_REPEAT2_DURATION;
					x.value |= 0x80;
				}
			}
		}
	}
        
	return(x.value);
}
/*---------------------------------------------------------------------------*/
/*																			 							*/
/*---------------------------------------------------------------------------*/
u8 BTN_GetStatus(void)
{
	return(ButtonPreviousStatus);
}
